/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.crafting.recipe;

import com.google.gson.JsonObject;
import committee.nova.mods.avaritia.api.common.crafting.ISpecialRecipe;
import committee.nova.mods.avaritia.init.handler.SingularityRegistryHandler;
import committee.nova.mods.avaritia.init.registry.ModItems;
import committee.nova.mods.avaritia.init.registry.ModRecipeSerializers;
import committee.nova.mods.avaritia.init.registry.ModRecipeTypes;
import committee.nova.mods.avaritia.util.SingularityUtils;
import java.util.ArrayList;
import java.util.function.BiFunction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.RecipeMatcher;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public class EternalSingularityCraftRecipe
implements ISpecialRecipe {
    private static boolean ingredientsLoaded = false;
    private final ResourceLocation recipeId;
    public NonNullList<Ingredient> inputs = NonNullList.m_122779_();
    private BiFunction<Integer, ItemStack, ItemStack> transformers;

    public EternalSingularityCraftRecipe(ResourceLocation recipeId) {
        this.recipeId = recipeId;
    }

    public static void invalidate() {
        ingredientsLoaded = false;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= this.inputs.size();
    }

    @NotNull
    public ItemStack m_8043_(@NotNull RegistryAccess pRegistryAccess) {
        return new ItemStack((ItemLike)ModItems.eternal_singularity.get());
    }

    @NotNull
    public NonNullList<Ingredient> m_7527_() {
        if (!ingredientsLoaded) {
            this.inputs.clear();
            SingularityRegistryHandler.getInstance().getSingularities().stream().filter(singularity -> singularity.getIngredient() != Ingredient.f_43901_).limit(81L).map(SingularityUtils::getItemForSingularity).map(xva$0 -> Ingredient.m_43927_((ItemStack[])new ItemStack[]{xva$0})).forEach(arg_0 -> this.inputs.add(arg_0));
            ingredientsLoaded = true;
        }
        return this.inputs;
    }

    @NotNull
    public ResourceLocation m_6423_() {
        return this.recipeId;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeSerializers.ETERNAL_SINGULARITY_CRAFT_SERIALIZER.get();
    }

    @NotNull
    public RecipeType<?> m_6671_() {
        return (RecipeType)ModRecipeTypes.EXTREME_CRAFT_RECIPE.get();
    }

    @Override
    public ItemStack assemble(IItemHandler var1) {
        return new ItemStack((ItemLike)ModItems.eternal_singularity.get());
    }

    @Override
    @NotNull
    public ItemStack m_5874_(@NotNull Container inv, @NotNull RegistryAccess p_267052_) {
        return new ItemStack((ItemLike)ModItems.eternal_singularity.get());
    }

    @Override
    public boolean matches(IItemHandler inventory) {
        NonNullList<Ingredient> ingredients = this.m_7527_();
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        int matched = 0;
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack stack = inventory.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            inputs.add(stack);
            ++matched;
        }
        return !ingredients.isEmpty() && matched == this.inputs.size() && RecipeMatcher.findMatches(inputs, this.inputs) != null;
    }

    @Override
    public boolean m_5818_(@NotNull Container inv, @NotNull Level level) {
        return this.matches((IItemHandler)new InvWrapper(inv));
    }

    @Override
    @NotNull
    public NonNullList<ItemStack> getRemainingItems(@NotNull IItemHandler inv) {
        NonNullList<ItemStack> remaining = ISpecialRecipe.super.getRemainingItems(inv);
        if (this.transformers != null) {
            boolean[] used = new boolean[remaining.size()];
            block0: for (int i = 0; i < remaining.size(); ++i) {
                ItemStack stack = inv.getStackInSlot(i);
                for (int j = 0; j < this.inputs.size(); ++j) {
                    Ingredient input = (Ingredient)this.inputs.get(j);
                    if (used[j] || !input.test(stack)) continue;
                    ItemStack ingredient = this.transformers.apply(j, stack);
                    used[j] = true;
                    remaining.set(i, (Object)ingredient);
                    continue block0;
                }
            }
        }
        return remaining;
    }

    public void setTransformers(BiFunction<Integer, ItemStack, ItemStack> transformers) {
        this.transformers = transformers;
    }

    public static class Serializer
    implements RecipeSerializer<EternalSingularityCraftRecipe> {
        @NotNull
        public EternalSingularityCraftRecipe fromJson(@NotNull ResourceLocation recipeId, @NotNull JsonObject json) {
            return new EternalSingularityCraftRecipe(recipeId);
        }

        public EternalSingularityCraftRecipe fromNetwork(@NotNull ResourceLocation recipeId, @NotNull FriendlyByteBuf buffer) {
            return new EternalSingularityCraftRecipe(recipeId);
        }

        public void toNetwork(@NotNull FriendlyByteBuf buffer, @NotNull EternalSingularityCraftRecipe recipe) {
        }
    }
}

